#include <bits/stdc++.h>
#define endl '\n'
#define ll long long

ll m, n, k = 0;
ll result = 0;

using namespace std;

bool possible(ll busFuel, ll pump[], ll requiredFuel[]){
    for(ll i = 0; i < n - 1; i++){
        busFuel += pump[i];
        if(busFuel < requiredFuel[i + 1]) return false;
        busFuel -= requiredFuel[i + 1];
    }

    return true;
}

bool calculate(ll busFuel, ll pump[], ll requiredFuel[]){
    ll reqBusFuel[n];
    reqBusFuel[n - 1] = requiredFuel[n - 1] - pump[n - 2];

    for(ll i = n - 2; i > 0; i--){
        reqBusFuel[i] = reqBusFuel[i + 1] + requiredFuel[i] - pump[i - 1];
    }

    if(reqBusFuel[1] > busFuel){
        return false;
    }

    for(ll i = 1; i < n; i++){
        ll fuelGrabbed = requiredFuel[i] - busFuel;
        if(fuelGrabbed < 0) fuelGrabbed = 0;
        pump[i - 1] -= fuelGrabbed;
        busFuel += fuelGrabbed - requiredFuel[i];
    }

    result++;
    return true;
}

ll calculateLeastFuelNeeded(ll busFuel, ll pump[], ll requiredFuel[], ll pumpIndex){
    ll fuelNeeded = 0;
    for(ll i = n - 1; i >= pumpIndex; i--){
        fuelNeeded += requiredFuel[i];
        fuelNeeded -= pump[i - 1];
    }

    return fuelNeeded;
}

bool takeFuel(ll busNew[], ll pump[], ll fuelReq, ll busIndex, ll pumpIndex){
    for(ll i = pumpIndex - 1; i >= 0; i--){
        ll busFuel = busNew[busIndex];
        ll fuelNeeded = fuelReq - busFuel;

        ll fuel = pump[i];
        if(fuel > fuelNeeded){
            fuel = fuelNeeded;
            pump[i] -= fuel;
            busNew[busIndex] += fuel;
            return true;
        }

        busNew[busIndex] += fuel;
        pump[i] = 0;
    }

    return busNew[busIndex] >= fuelReq;
}

int main(){
    ios::sync_with_stdio(false); cin.tie(0);
    cin>>m>>n;

    ll fuelReq = 0;
    ll bus[m], stations[n], pump[n], requiredFuel[n], totalReqFuel[n];

    totalReqFuel[0] = 0;
    requiredFuel[0] = 0;

    for(ll i = 0; i < m; i++) cin>>bus[i];
    for(ll i = 0; i < n; i++) {
        cin>>stations[i];
        if(i > 0){
            requiredFuel[i] = abs(stations[i] - stations[i - 1]);
            fuelReq += requiredFuel[i];
            totalReqFuel[i] = totalReqFuel[i - 1] + requiredFuel[i];
        }
    }

    for(ll i = 0; i < n; i++) cin>>pump[i];

    ll busNew[m];
    for(ll i = 0; i < m; i++){
        if(bus[i] >= fuelReq){
            result++;
        }else{
            busNew[k++] = bus[i];
        }
    }

    sort(busNew, busNew + k);

    for(ll i = k - 1; i >= 0; i--){
        if(!calculate(busNew[i], pump, requiredFuel)) break;
    }

    /*bool canContinue = true;
    for(ll i = k - 1; i >= 0; i--){
        for(ll o = 1; o < n; o++){
            if(busNew[i] < totalReqFuel[o]){
                bool b = takeFuel(busNew, pump, totalReqFuel[o], i, o);
                if(!b){ //Nema vise goriva
                    canContinue = false;
                    break;
                }
            }else if(o == n - 1) result++;
        }

        if(!canContinue) break;
    }*/

    cout<<result;
    return 0;
}